/*
 * Decompiled with CFR 0.152.
 */
package fr.cnes.sitools.common;

import fr.cnes.sitools.common.JarFile;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;

public final class JarFileApplication {
    private JarFileApplication() {
    }

    public static void main(String[] argv) throws Exception {
        int c;
        LongOpt[] longopts = new LongOpt[5];
        StringBuilder sb = new StringBuilder();
        longopts[0] = new LongOpt("help", 0, null, 104);
        longopts[1] = new LongOpt("tmp_directory", 1, null, 1);
        longopts[2] = new LongOpt("directory", 1, null, 2);
        longopts[3] = new LongOpt("jar_library", 1, null, 3);
        longopts[4] = new LongOpt("jar_target", 1, null, 4);
        Getopt g = new Getopt("UpdateClasspath", argv, "h", longopts);
        g.setOpterr(false);
        String tmpDirectory = null;
        String directory = null;
        String jarLibrary = null;
        String jarTarget = null;
        block8: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 0: {
                    String arg = g.getOptarg();
                    System.out.println("Got long option with value '" + (char)new Integer(sb.toString()).intValue() + "' with argument " + (arg != null ? arg : "null"));
                    continue block8;
                }
                case 1: {
                    tmpDirectory = g.getOptarg();
                    continue block8;
                }
                case 2: {
                    directory = g.getOptarg();
                    continue block8;
                }
                case 3: {
                    jarLibrary = g.getOptarg();
                    continue block8;
                }
                case 4: {
                    jarTarget = g.getOptarg();
                    continue block8;
                }
                case 104: {
                    JarFileApplication.usage();
                    continue block8;
                }
            }
            JarFileApplication.usage();
        }
        for (int i = g.getOptind(); i < argv.length; ++i) {
            System.out.println("Non option argv element: " + argv[i] + "\n");
        }
        if (tmpDirectory == null && jarTarget == null) {
            JarFileApplication.usage();
            System.exit(1);
        } else if (jarLibrary == null && directory == null) {
            JarFileApplication.usage();
            System.exit(1);
        } else if (jarLibrary != null && directory != null) {
            JarFileApplication.usage();
            System.exit(1);
        }
        JarFile jarFile = new JarFile(new File(jarTarget));
        jarFile.setDirectoryTmp(new File(tmpDirectory));
        if (jarLibrary != null) {
            jarFile.addLibraryToClasspath(new File(jarLibrary));
        } else if (directory != null) {
            File d = new File(directory);
            if (!d.isDirectory()) {
                System.exit(2);
            }
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("jar");
                }
            };
            File[] files = d.listFiles(filter);
            jarFile.addLibrariesToClasspath(Arrays.asList(files));
        }
        System.exit(0);
    }

    public static void usage() {
        System.out.println("USAGE: UpdateClasspath [-h|--help] --tmp_directory=<> --directory=<>[|--jar_library=<>] --jar_target=<>");
        System.out.println("--tmp_directory : tmp directory (required)");
        System.out.println("--directory : list all jars in this directory and add them in the classpath when they are not present");
        System.out.println("--jar_library : add only one jar in the classpath");
        System.out.println("--jar_target : Jar in which the Manifest will be updated (required)");
        System.exit(1);
    }
}

