/*
 * Decompiled with CFR 0.152.
 */
package fr.cnes.sitools.common;

import fr.cnes.sitools.common.JarFileException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class JarFile {
    private static final String TMP_JAR_FILE_NAME = "manifest";
    private final File jarFileName;
    private File directoryTmp = null;

    public JarFile(File filename) {
        this.jarFileName = filename;
    }

    public JarFile(File filename, File directoryTmp) {
        this.jarFileName = filename;
        this.directoryTmp = directoryTmp;
    }

    public void addLibraryToClasspath(File jarFileLibrary) throws JarFileException {
        this.addLibrariesToClasspath(Arrays.asList(jarFileLibrary));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLibrariesToClasspath(List<File> jarFileLibraries) throws JarFileException {
        java.util.jar.JarFile jarFileInput = null;
        ZipOutputStream zipFileTarget = null;
        if (this.directoryTmp.isDirectory()) {
            File targetFile = null;
            try {
                jarFileInput = new java.util.jar.JarFile(this.jarFileName);
                Manifest baseMf = this.getBaseManifest(jarFileInput);
                Manifest mf = jarFileInput.getManifest();
                targetFile = new File(this.directoryTmp + File.separator + TMP_JAR_FILE_NAME + ".jar");
                zipFileTarget = new ZipOutputStream(new FileOutputStream(targetFile));
                if (baseMf == null) {
                    this.addAManifestInJarFile(mf, zipFileTarget, "META-INF/MANIFEST.MF.BASE");
                } else {
                    mf = baseMf;
                }
                this.addClasspathToManifest(jarFileLibraries, mf);
                this.copyJarToTmpJar(jarFileInput, zipFileTarget);
                File tmpFile = new File(this.directoryTmp + File.separator + TMP_JAR_FILE_NAME);
                this.addManifestInJarFile(tmpFile, zipFileTarget);
                tmpFile.delete();
            }
            catch (ZipException ex) {
                ex.printStackTrace();
                Logger.getLogger(JarFile.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                Logger.getLogger(JarFile.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    if (jarFileInput != null) {
                        jarFileInput.close();
                    }
                    if (zipFileTarget != null) {
                        zipFileTarget.close();
                    }
                    if (targetFile != null) {
                        this.jarFileName.delete();
                        targetFile.renameTo(this.jarFileName);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    Logger.getLogger(JarFile.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            throw new JarFileException("directory_tmp is not set");
        }
    }

    private void copyJarToTmpJar(ZipFile zipfile, ZipOutputStream zipFileTarget) throws JarFileException {
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            if (ze.getName().equals("META-INF/MANIFEST.MF")) continue;
            try {
                this.copyZiptoTmpZip(ze, new BufferedInputStream(zipfile.getInputStream(ze)), zipFileTarget);
            }
            catch (IOException ex) {
                Logger.getLogger(JarFile.class.getName()).log(Level.SEVERE, null, ex);
                throw new JarFileException(ex.getMessage());
            }
        }
    }

    private Manifest getBaseManifest(ZipFile zipFile) throws JarFileException {
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        Manifest mf = null;
        while (e.hasMoreElements() && mf == null) {
            ZipEntry ze = e.nextElement();
            if (!ze.getName().equals("META-INF/MANIFEST.MF.BASE")) continue;
            try {
                mf = new Manifest(zipFile.getInputStream(ze));
            }
            catch (IOException ex) {
                Logger.getLogger(JarFile.class.getName()).log(Level.SEVERE, null, ex);
                throw new JarFileException(ex.getMessage());
            }
        }
        return mf;
    }

    private void addAManifestInJarFile(Manifest mf, ZipOutputStream outputFileZip, String fileName) throws IOException {
        outputFileZip.putNextEntry(new ZipEntry(fileName));
        mf.write(outputFileZip);
        outputFileZip.closeEntry();
    }

    private void addClasspathToManifest(List<File> jarFileLibraries, Manifest mf) throws IOException {
        String classpathValue = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        StringBuilder libraries = new StringBuilder();
        Iterator<File> iterFile = jarFileLibraries.iterator();
        while (iterFile.hasNext()) {
            libraries.append(" ");
            libraries.append(iterFile.next().getPath());
        }
        mf.getMainAttributes().putValue(Attributes.Name.CLASS_PATH.toString(), classpathValue + libraries.toString());
        FileOutputStream fos = new FileOutputStream(new File(this.directoryTmp + File.separator + TMP_JAR_FILE_NAME));
        mf.write(fos);
        fos.close();
    }

    private void copyZiptoTmpZip(ZipEntry entry, BufferedInputStream in, ZipOutputStream outputFileZip) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        outputFileZip.putNextEntry(entry);
        while ((len = in.read(buf)) > 0) {
            outputFileZip.write(buf, 0, len);
        }
        outputFileZip.closeEntry();
        in.close();
    }

    private void addManifestInJarFile(File manifestFile, ZipOutputStream outputFileZip) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(manifestFile);
        byte[] buf = new byte[1024];
        outputFileZip.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
        while ((len = ((InputStream)in).read(buf)) > 0) {
            outputFileZip.write(buf, 0, len);
        }
        outputFileZip.closeEntry();
        ((InputStream)in).close();
    }

    public void setDirectoryTmp(File directoryTmp) throws JarFileException {
        if (!directoryTmp.isDirectory()) {
            throw new JarFileException(directoryTmp + " is not a directory");
        }
        this.directoryTmp = directoryTmp;
    }

    public static void main(String[] args) throws JarFileException {
        JarFile jarFile = new JarFile(new File("fr.cnes.sitools.core.jar"));
        jarFile.setDirectoryTmp(new File("ext"));
        jarFile.addLibraryToClasspath(new File("ext/fr.cnes.sitools.ext.jar"));
    }
}

