/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.security;

import junit.framework.TestCase;
import org.junit.Test;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.ext.crypto.DigestAuthenticator;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.restlet.routing.Router;
import org.restlet.security.LocalVerifier;
import org.restlet.security.MapVerifier;

public class HttpDigestTestCase
extends TestCase {
    private Component component;
    private int port;

    protected void setUp() throws Exception {
        this.component = new Component();
        Server server = this.component.getServers().add(Protocol.HTTP, 0);
        MyApplication application = new MyApplication();
        this.component.getDefaultHost().attach((Restlet)application);
        this.component.start();
        this.port = server.getEphemeralPort();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.component.stop();
        this.component = null;
        super.tearDown();
    }

    @Test
    public void testDigest() throws Exception {
        ClientResource cr = new ClientResource("http://localhost:" + this.port + "/");
        try {
            cr.get();
        }
        catch (ResourceException re) {
            HttpDigestTestCase.assertEquals((Object)Status.CLIENT_ERROR_UNAUTHORIZED, (Object)cr.getStatus());
            ChallengeRequest c1 = null;
            for (ChallengeRequest challengeRequest : cr.getChallengeRequests()) {
                if (!ChallengeScheme.HTTP_DIGEST.equals((Object)challengeRequest.getScheme())) continue;
                c1 = challengeRequest;
                break;
            }
            HttpDigestTestCase.assertEquals((Object)ChallengeScheme.HTTP_DIGEST, (Object)c1.getScheme());
            String realm = c1.getRealm();
            HttpDigestTestCase.assertEquals((String)"TestRealm", (String)realm);
            cr.getRequest().setMethod(Method.GET);
            ChallengeResponse c2 = new ChallengeResponse(c1, cr.getResponse(), "scott", "tiger".toCharArray());
            cr.setChallengeResponse(c2);
            cr.get();
            HttpDigestTestCase.assertTrue((boolean)cr.getStatus().isSuccess());
        }
    }

    private static class MyApplication
    extends Application {
        private MyApplication() {
        }

        public Restlet createInboundRoot() {
            Router router = new Router(this.getContext());
            DigestAuthenticator da = new DigestAuthenticator(this.getContext(), "TestRealm", "mySecretServerKey");
            MapVerifier mapVerifier = new MapVerifier();
            mapVerifier.getLocalSecrets().put("scott", "tiger".toCharArray());
            da.setWrappedVerifier((LocalVerifier)mapVerifier);
            Restlet restlet = new Restlet(this.getContext()){

                public void handle(Request request, Response response) {
                    response.setEntity("hello, world", MediaType.TEXT_PLAIN);
                }
            };
            da.setNext(restlet);
            router.attach("/", (Restlet)da);
            return router;
        }
    }
}

