/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.routing;

import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Status;
import org.restlet.routing.Validator;
import org.restlet.test.RestletTestCase;
import org.restlet.test.TraceRestlet;

public class ValidatorTestCase
extends RestletTestCase {
    public void testRequired() {
        Request rq = new Request();
        Response rs = new Response(rq);
        Validator validator = new Validator();
        validator.setNext((Restlet)new TraceRestlet(null));
        validator.validatePresence("a");
        validator.handle(rq, rs);
        ValidatorTestCase.assertEquals((Object)Status.CLIENT_ERROR_BAD_REQUEST, (Object)rs.getStatus());
        rq.getAttributes().put("a", "123");
        rs.setStatus(Status.SUCCESS_OK);
        validator.handle(rq, rs);
        ValidatorTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)rs.getStatus());
    }

    public void testFormat() {
        Request rq = new Request();
        Response rs = new Response(rq);
        Validator validator = new Validator();
        validator.setNext((Restlet)new TraceRestlet(null));
        validator.validateFormat("a", "\\d*");
        validator.handle(rq, rs);
        ValidatorTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)rs.getStatus());
        rq.getAttributes().put("a", "abc");
        rs.setStatus(Status.SUCCESS_OK);
        validator.handle(rq, rs);
        ValidatorTestCase.assertEquals((Object)Status.CLIENT_ERROR_BAD_REQUEST, (Object)rs.getStatus());
        rq.getAttributes().put("a", "123");
        rs.setStatus(Status.SUCCESS_OK);
        validator.handle(rq, rs);
        ValidatorTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)rs.getStatus());
    }
}

