/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.resource;

import java.io.IOException;
import junit.framework.TestCase;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Protocol;
import org.restlet.engine.Engine;
import org.restlet.resource.ResourceException;
import org.restlet.routing.Router;
import org.restlet.test.resource.MyResource9;

public class AnnotatedResource9TestCase
extends TestCase {
    public static final Method SI = new Method("SI", "What a method!", "http://www.restlet.org", true, true);
    public static final Method SNI = new Method("SNI", "What a method!", "http://www.restlet.org", true, false);
    public static final Method USI = new Method("USI", "What a method!", "http://www.restlet.org", false, true);
    public static final Method USNI = new Method("USNI", "What a method!", "http://www.restlet.org", false, false);
    private Component c;
    private Client client;

    protected void setUp() throws Exception {
        Engine.getInstance().getRegisteredConverters().clear();
        Engine.getInstance().registerDefaultConverters();
        this.c = new Component();
        this.c.getServers().add(Protocol.HTTP, 8111);
        this.c.getDefaultHost().attach((Restlet)new TestApplication());
        this.c.start();
        this.client = new Client(Protocol.HTTP);
    }

    protected void tearDown() throws Exception {
        this.c.stop();
        this.c = null;
        this.client = null;
        Engine.register();
    }

    public void testSI() throws IOException, ResourceException {
        Method method = SI;
        String text = "text";
        Form form = new Form();
        form.add("key", "value");
        this.client = new Client(Protocol.HTTP);
        Request request = new Request(method, "http://localhost:8111/test");
        Response response = this.client.handle(request);
        AnnotatedResource9TestCase.assertTrue((boolean)response.getStatus().isSuccess());
        response.getEntity().release();
        request = new Request(method, "http://localhost:8111/test");
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_HTML));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_HTML, (Object)response.getEntity().getMediaType());
        response.getEntity().release();
        request = new Request(method, "http://localhost:8111/test");
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_PLAIN));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)response.getEntity().getMediaType());
        response.getEntity().release();
        request = new Request(method, "http://localhost:8111/test");
        request.setEntity(text, MediaType.TEXT_PLAIN);
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_HTML));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_HTML, (Object)response.getEntity().getMediaType());
        AnnotatedResource9TestCase.assertEquals((String)"si-html+txt", (String)response.getEntity().getText());
        request = new Request(method, "http://localhost:8111/test");
        request.setEntity(form.getWebRepresentation());
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_PLAIN));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)response.getEntity().getMediaType());
        AnnotatedResource9TestCase.assertEquals((String)"si-string+form", (String)response.getEntity().getText());
        request = new Request(method, "http://localhost:8111/test");
        request.setEntity(text, MediaType.TEXT_PLAIN);
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_PLAIN));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)response.getEntity().getMediaType());
        AnnotatedResource9TestCase.assertEquals((String)"si-string+text", (String)response.getEntity().getText());
        request = new Request(method, "http://localhost:8111/test");
        request.setEntity(form.getWebRepresentation());
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_HTML, (Object)response.getEntity().getMediaType());
        AnnotatedResource9TestCase.assertEquals((String)"si-html+form", (String)response.getEntity().getText());
    }

    public void testSNI() throws IOException, ResourceException {
        Method method = SNI;
        String text = "text";
        Form form = new Form();
        form.add("key", "value");
        this.client = new Client(Protocol.HTTP);
        Request request = new Request(method, "http://localhost:8111/test");
        Response response = this.client.handle(request);
        AnnotatedResource9TestCase.assertTrue((boolean)response.getStatus().isSuccess());
        response.getEntity().release();
        request = new Request(method, "http://localhost:8111/test");
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_HTML));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_HTML, (Object)response.getEntity().getMediaType());
        response.getEntity().release();
        request = new Request(method, "http://localhost:8111/test");
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_PLAIN));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)response.getEntity().getMediaType());
        response.getEntity().release();
        request = new Request(method, "http://localhost:8111/test");
        request.setEntity(text, MediaType.TEXT_PLAIN);
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_HTML));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_HTML, (Object)response.getEntity().getMediaType());
        AnnotatedResource9TestCase.assertEquals((String)"sni-html+txt", (String)response.getEntity().getText());
        request = new Request(method, "http://localhost:8111/test");
        request.setEntity(form.getWebRepresentation());
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_PLAIN));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_HTML, (Object)response.getEntity().getMediaType());
        AnnotatedResource9TestCase.assertEquals((String)"sni-html+form", (String)response.getEntity().getText());
        request = new Request(method, "http://localhost:8111/test");
        request.setEntity(text, MediaType.TEXT_PLAIN);
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_PLAIN));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)response.getEntity().getMediaType());
        AnnotatedResource9TestCase.assertEquals((String)"sni-string+text", (String)response.getEntity().getText());
    }

    public void testUSI() throws IOException, ResourceException {
        Method method = USI;
        String text = "text";
        Form form = new Form();
        form.add("key", "value");
        this.client = new Client(Protocol.HTTP);
        Request request = new Request(method, "http://localhost:8111/test");
        Response response = this.client.handle(request);
        AnnotatedResource9TestCase.assertTrue((boolean)response.getStatus().isSuccess());
        response.getEntity().release();
        request = new Request(method, "http://localhost:8111/test");
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_HTML));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_HTML, (Object)response.getEntity().getMediaType());
        response.getEntity().release();
        request = new Request(method, "http://localhost:8111/test");
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_PLAIN));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)response.getEntity().getMediaType());
        response.getEntity().release();
        request = new Request(method, "http://localhost:8111/test");
        request.setEntity(text, MediaType.TEXT_PLAIN);
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_HTML));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)response.getEntity().getMediaType());
        AnnotatedResource9TestCase.assertEquals((String)"usi-string+text", (String)response.getEntity().getText());
        request = new Request(method, "http://localhost:8111/test");
        request.setEntity(form.getWebRepresentation());
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_PLAIN));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)response.getEntity().getMediaType());
        AnnotatedResource9TestCase.assertEquals((String)"usi-string+form", (String)response.getEntity().getText());
        request = new Request(method, "http://localhost:8111/test");
        request.setEntity(text, MediaType.TEXT_PLAIN);
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_PLAIN));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)response.getEntity().getMediaType());
        AnnotatedResource9TestCase.assertEquals((String)"usi-string+text", (String)response.getEntity().getText());
        request = new Request(USI, "http://localhost:8111/test");
        request.setEntity(form.getWebRepresentation());
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_PLAIN));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)response.getEntity().getMediaType());
        AnnotatedResource9TestCase.assertEquals((String)"usi-string+form", (String)response.getEntity().getText());
        request = new Request(USI, "http://localhost:8111/test");
        request.setEntity(form.getWebRepresentation());
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_HTML));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)response.getEntity().getMediaType());
        AnnotatedResource9TestCase.assertEquals((String)"usi-string+form", (String)response.getEntity().getText());
    }

    public void testUSNI() throws IOException, ResourceException {
        Method method = USNI;
        String text = "text";
        Form form = new Form();
        form.add("key", "value");
        this.client = new Client(Protocol.HTTP);
        Request request = new Request(method, "http://localhost:8111/test");
        Response response = this.client.handle(request);
        AnnotatedResource9TestCase.assertTrue((boolean)response.getStatus().isSuccess());
        response.getEntity().release();
        request = new Request(method, "http://localhost:8111/test");
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_HTML));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_HTML, (Object)response.getEntity().getMediaType());
        response.getEntity().release();
        request = new Request(method, "http://localhost:8111/test");
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_PLAIN));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)response.getEntity().getMediaType());
        response.getEntity().release();
        request = new Request(method, "http://localhost:8111/test");
        request.setEntity(text, MediaType.TEXT_PLAIN);
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_HTML));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_HTML, (Object)response.getEntity().getMediaType());
        AnnotatedResource9TestCase.assertEquals((String)"usni-html+txt", (String)response.getEntity().getText());
        request = new Request(method, "http://localhost:8111/test");
        request.setEntity(form.getWebRepresentation());
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_HTML));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_HTML, (Object)response.getEntity().getMediaType());
        AnnotatedResource9TestCase.assertEquals((String)"usni-html+form", (String)response.getEntity().getText());
        request = new Request(method, "http://localhost:8111/test");
        request.setEntity(text, MediaType.TEXT_PLAIN);
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_PLAIN));
        response = this.client.handle(request);
        AnnotatedResource9TestCase.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)response.getEntity().getMediaType());
        AnnotatedResource9TestCase.assertEquals((String)"usni-string+text", (String)response.getEntity().getText());
    }

    private static class TestApplication
    extends Application {
        private TestApplication() {
        }

        public Restlet createInboundRoot() {
            Router router = new Router(this.getContext());
            router.attach("/test", MyResource9.class);
            return router;
        }
    }
}

