/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Conditions;
import org.restlet.data.Cookie;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Preference;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.io.NioUtils;
import org.restlet.representation.Representation;
import org.restlet.security.ChallengeAuthenticator;
import org.restlet.security.MemoryRealm;
import org.restlet.security.User;
import org.restlet.test.jaxrs.server.DirectServerWrapper;
import org.restlet.test.jaxrs.server.DirectServerWrapperFactory;
import org.restlet.test.jaxrs.server.RestletServerWrapperFactory;
import org.restlet.test.jaxrs.server.ServerWrapper;
import org.restlet.test.jaxrs.server.ServerWrapperFactory;
import org.restlet.util.WrapperRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RestletServerTestCase
extends TestCase {
    public static final String ORG_RESTLET_HTTP_HEADERS = "org.restlet.http.headers";
    private static ServerWrapperFactory serverWrapperFactory;
    private static boolean usingTcp;
    protected ServerWrapper serverWrapper;

    static void addAcceptedMediaTypes(Request request, Collection mediaTypes) {
        if (mediaTypes == null || mediaTypes.isEmpty()) {
            return;
        }
        ArrayList<Preference> mediaTypePrefs = new ArrayList<Preference>(mediaTypes.size());
        for (Object mediaType : mediaTypes) {
            Preference preference;
            if (mediaType instanceof MediaType) {
                mediaTypePrefs.add(new Preference((Metadata)((MediaType)mediaType)));
                continue;
            }
            if (mediaType instanceof Preference && (preference = (Preference)mediaType).getMetadata() instanceof MediaType) {
                mediaTypePrefs.add(preference);
                continue;
            }
            throw new IllegalArgumentException("Valid mediaTypes are only Preference<MediaType> or MediaType");
        }
        request.getClientInfo().getAcceptedMediaTypes().addAll(mediaTypePrefs);
    }

    public static ChallengeAuthenticator createAuthenticator(Context context, ChallengeScheme challengeScheme) {
        MemoryRealm realm = new MemoryRealm();
        realm.getUsers().add(new User("admin", "adminPW".toCharArray()));
        realm.getUsers().add(new User("alice", "alicesSecret".toCharArray()));
        realm.getUsers().add(new User("bob", "bobsSecret".toCharArray()));
        context.setDefaultEnroler(realm.getEnroler());
        context.setDefaultVerifier(realm.getVerifier());
        return new ChallengeAuthenticator(context, challengeScheme, "");
    }

    public static Form getHttpHeaders(Request request) {
        Form headers = (Form)request.getAttributes().get(ORG_RESTLET_HTTP_HEADERS);
        if (headers == null) {
            headers = new Form();
            request.getAttributes().put(ORG_RESTLET_HTTP_HEADERS, headers);
        }
        return headers;
    }

    public static ServerWrapperFactory getServerWrapperFactory() {
        if (serverWrapperFactory == null) {
            serverWrapperFactory = usingTcp ? new RestletServerWrapperFactory() : new DirectServerWrapperFactory();
        }
        return serverWrapperFactory;
    }

    public static void setServerWrapperFactory(ServerWrapperFactory swf) {
        if (swf == null) {
            throw new IllegalArgumentException("null is an illegal ServerWrapperFactory");
        }
        serverWrapperFactory = swf;
    }

    public static void setUseTcp(boolean usingTcp) {
        if (usingTcp) {
            if (serverWrapperFactory != null && !serverWrapperFactory.usesTcp()) {
                serverWrapperFactory = null;
            }
        } else if (serverWrapperFactory != null && serverWrapperFactory.usesTcp()) {
            serverWrapperFactory = null;
        }
        RestletServerTestCase.usingTcp = usingTcp;
    }

    public static void sysOutEntity(Response response) {
        Representation entity = response.getEntity();
        try {
            if (entity != null) {
                System.out.println(entity.getText());
            } else {
                System.out.println("[no Entity available]");
            }
        }
        catch (IOException e) {
            System.out.println("Entity not readable: ");
            e.printStackTrace(System.out);
        }
    }

    public static void sysOutEntityIfError(Response response) {
        if (response.getStatus().isError()) {
            RestletServerTestCase.sysOutEntity(response);
        }
    }

    public static void sysOutEntityIfNotStatus(Status status, Response response) {
        if (!response.getStatus().equals((Object)status)) {
            RestletServerTestCase.sysOutEntity(response);
        }
    }

    public static boolean usesTcp() {
        return usingTcp;
    }

    public RestletServerTestCase() {
    }

    public RestletServerTestCase(String name) {
        super(name);
    }

    public Response accessServer(Method httpMethod, Reference reference) {
        return this.accessServer(httpMethod, reference, null, null, null, null, null, null);
    }

    public Response accessServer(Method httpMethod, Reference reference, Collection accMediaTypes, Representation entity, ChallengeResponse challengeResponse, Conditions conditions, Collection<Cookie> addCookies, Collection<Parameter> addHeaders) {
        Request request = new Request(httpMethod, reference);
        RestletServerTestCase.addAcceptedMediaTypes(request, accMediaTypes);
        request.setChallengeResponse(challengeResponse);
        request.setEntity(entity);
        request.setConditions(conditions);
        if (addCookies != null) {
            request.getCookies().addAll(addCookies);
        }
        if (addHeaders != null) {
            RestletServerTestCase.getHttpHeaders(request).addAll(addHeaders);
        }
        return this.accessServer(request);
    }

    public Response accessServer(Request request) {
        Reference reference = request.getResourceRef();
        if (reference.getBaseRef() == null) {
            reference.setBaseRef(reference.getHostIdentifier());
        }
        request.setOriginalRef(reference.getTargetRef());
        Restlet connector = this.getClientConnector();
        if (this.shouldAccessWithoutTcp()) {
            String hostDomain = request.getResourceRef().getHostDomain();
            RestletServerTestCase.getHttpHeaders(request).add("host", hostDomain);
        }
        Response response = new Response(request);
        connector.handle(request, response);
        if (!usingTcp && request.getMethod().equals((Object)Method.HEAD)) {
            response.setEntity((Representation)new WrapperRepresentation(response.getEntity()){

                public ReadableByteChannel getChannel() throws IOException {
                    return NioUtils.getChannel((InputStream)this.getStream());
                }

                public Reader getReader() throws IOException {
                    return new StringReader("");
                }

                public InputStream getStream() throws IOException {
                    return new ByteArrayInputStream(new byte[0]);
                }

                public String getText() {
                    return null;
                }

                public boolean isAvailable() {
                    return false;
                }

                public void write(OutputStream outputStream) throws IOException {
                }

                public void write(WritableByteChannel writableChannel) throws IOException {
                }

                public void write(Writer writer) throws IOException {
                }
            });
        }
        return response;
    }

    protected abstract Application createApplication();

    protected Reference createBaseRef() {
        Reference reference = new Reference();
        reference.setProtocol(Protocol.HTTP);
        reference.setAuthority("localhost");
        if (!this.shouldAccessWithoutTcp()) {
            reference.setHostPort(Integer.valueOf(this.getServerWrapper().getServerPort()));
        }
        return reference;
    }

    private Restlet getClientConnector() {
        return this.getServerWrapper().getClientConnector();
    }

    public int getServerPort() {
        return this.getServerWrapper().getServerPort();
    }

    public ServerWrapper getServerWrapper() {
        if (this.serverWrapper == null) {
            this.serverWrapper = RestletServerTestCase.getServerWrapperFactory().createServerWrapper();
        }
        return this.serverWrapper;
    }

    protected void runServerAfterStart() {
        System.out.print("server is accessable via http://localhost:");
        System.out.println(this.getServerPort());
    }

    public void runServerUntilKeyPressed() throws Exception {
        RestletServerTestCase.setUseTcp(true);
        this.startServer(this.createApplication());
        this.runServerAfterStart();
        System.out.println("press key to stop . . .");
        System.in.read();
        this.stopServer();
        System.out.println("server stopped");
    }

    public void setServerWrapper(ServerWrapper serverWrapper) {
        this.serverWrapper = serverWrapper;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.shouldStartServerInSetUp()) {
            this.startServer(this.createApplication());
        }
    }

    public boolean shouldAccessWithoutTcp() {
        return this.getServerWrapper() instanceof DirectServerWrapper;
    }

    public boolean shouldStartServerInSetUp() {
        return true;
    }

    public void startServer() throws Exception {
        this.startServer(this.createApplication());
    }

    public void startServer(Application application) throws Exception {
        this.startServer(application, Protocol.HTTP);
    }

    protected void startServer(Application jaxRsApplication, Protocol protocol) throws Exception {
        try {
            this.getServerWrapper().startServer(jaxRsApplication, protocol);
        }
        catch (Exception e) {
            try {
                this.stopServer();
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
    }

    protected void stopServer() throws Exception {
        if (this.serverWrapper != null) {
            this.serverWrapper.stopServer();
        }
        this.serverWrapper = null;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.stopServer();
    }

    static {
        usingTcp = false;
    }
}

