/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.core;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.ws.rs.core.UriBuilder;
import junit.framework.AssertionFailedError;
import junit.framework.ComparisonFailure;
import junit.framework.TestCase;
import org.restlet.Application;
import org.restlet.data.Reference;
import org.restlet.ext.jaxrs.ExtendedUriBuilder;
import org.restlet.test.jaxrs.core.UriBuilderImplTest;
import org.restlet.test.jaxrs.services.car.CarListResource;
import org.restlet.test.jaxrs.services.car.CarResource;
import org.restlet.test.jaxrs.services.resources.SimpleTrain;

public class ExtendedJaxRsUriBuilderTest
extends TestCase {
    private static final String TEMPL_VARS_EXPECTED = "abc://username:password@www.secure.org:8080/def/ghi;jkl=mno/pqr.yz;stu=vwx?ABC=DEF&GHI=JKL#MNO";
    private static final URI URI_NO_EXT;
    private ExtendedUriBuilder uriBuilder;
    private ExtendedUriBuilder uriBuilderWithVars;

    static void assertEqualsURI(String expectedUri, URI actualUri) throws URISyntaxException {
        UriBuilderImplTest.assertEqualsURI(expectedUri, actualUri);
    }

    static void assertEqualsURI(String expectedUri, ExtendedUriBuilder actualBuilder) throws Exception {
        UriBuilderImplTest.assertEqualsURI(expectedUri, (UriBuilder)actualBuilder);
    }

    static void assertEqualsURI(String expectedUri, ExtendedUriBuilder actualBuilder, boolean encode) throws Exception {
        UriBuilderImplTest.assertEqualsURI(expectedUri, (UriBuilder)actualBuilder, encode);
    }

    static void assertEqualsUriSlashAllowed(String expectedUri, ExtendedUriBuilder actual) throws URISyntaxException {
        UriBuilderImplTest.assertEqualsUriSlashAllowed(expectedUri, (UriBuilder)actual);
    }

    private static void assertEqualUriBuilder(String expectedScheme, String expectedUserInfo, String expectedHost, String expectedPort, String expectedPath, String expectedExtension, String expectedQuery, ExtendedUriBuilder actualUriBuilder, boolean compareResult) throws Exception {
        block8: {
            ExtendedJaxRsUriBuilderTest.assertEquals((String)expectedScheme, (String)ExtendedJaxRsUriBuilderTest.getScheme(actualUriBuilder));
            ExtendedJaxRsUriBuilderTest.assertEquals((String)expectedUserInfo, (String)ExtendedJaxRsUriBuilderTest.getUserInfo(actualUriBuilder));
            ExtendedJaxRsUriBuilderTest.assertEquals((String)expectedHost, (String)ExtendedJaxRsUriBuilderTest.getHost(actualUriBuilder));
            ExtendedJaxRsUriBuilderTest.assertEquals((String)expectedPort, (String)ExtendedJaxRsUriBuilderTest.getPort(actualUriBuilder));
            String actPath = ExtendedJaxRsUriBuilderTest.getPath(actualUriBuilder);
            try {
                ExtendedJaxRsUriBuilderTest.assertEquals((String)expectedPath, (String)actPath);
            }
            catch (ComparisonFailure cf) {
                if (expectedPath != null) break block8;
                ExtendedJaxRsUriBuilderTest.assertEquals((String)"", (String)actPath);
            }
        }
        ExtendedJaxRsUriBuilderTest.assertEquals((String)expectedExtension, (String)actualUriBuilder.getExtension());
        String actualQuery = ExtendedJaxRsUriBuilderTest.getQuery(actualUriBuilder);
        if (actualQuery != null) {
            actualQuery = actualQuery.toString();
        }
        ExtendedJaxRsUriBuilderTest.assertEquals((Object)expectedQuery, (Object)actualQuery);
        if (compareResult) {
            ExtendedUriBuilder expectedUriBuilder = ExtendedUriBuilder.newInstance();
            if (expectedScheme != null) {
                expectedUriBuilder.scheme(expectedScheme);
            }
            if (expectedUserInfo != null) {
                expectedUriBuilder.userInfo(expectedUserInfo);
            }
            if (expectedHost != null) {
                expectedUriBuilder.host(expectedHost);
            }
            expectedUriBuilder.port(expectedPort);
            expectedUriBuilder.path(expectedPath);
            expectedUriBuilder.extension(expectedExtension);
            if (expectedQuery != null) {
                expectedUriBuilder.replaceQuery(expectedQuery);
            }
            String expectedURI = expectedUriBuilder.build(new Object[0]).toString();
            String atualURI = actualUriBuilder.build(new Object[0]).toString();
            ExtendedJaxRsUriBuilderTest.assertEquals((String)expectedURI, (String)atualURI);
        }
    }

    private static String getHost(ExtendedUriBuilder uriBuilderImpl) throws Exception {
        return UriBuilderImplTest.getFieldValue((UriBuilder)uriBuilderImpl, "host");
    }

    private static String getPath(ExtendedUriBuilder uriBuilderImpl) throws Exception {
        String path = UriBuilderImplTest.getFieldValue((UriBuilder)uriBuilderImpl, "path");
        if (path == null) {
            return null;
        }
        return path.toString();
    }

    private static String getPort(ExtendedUriBuilder uriBuilderImpl) throws Exception {
        return UriBuilderImplTest.getFieldValue((UriBuilder)uriBuilderImpl, "port");
    }

    private static String getQuery(ExtendedUriBuilder uriBuilderImpl) throws Exception {
        return UriBuilderImplTest.getFieldValue((UriBuilder)uriBuilderImpl, "query");
    }

    private static String getScheme(ExtendedUriBuilder uriBuilderImpl) throws Exception {
        return UriBuilderImplTest.getFieldValue((UriBuilder)uriBuilderImpl, "scheme");
    }

    private static String getUserInfo(ExtendedUriBuilder uriBuilderImpl) throws Exception {
        return UriBuilderImplTest.getFieldValue((UriBuilder)uriBuilderImpl, "userInfo");
    }

    private URI buildFromTemplVarsWithMap(ExtendedUriBuilder uriBuilder) {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("scheme", "abc");
        vars.put("userInfo", "username:password");
        vars.put("host", "www.secure.org");
        vars.put("port", "8080");
        vars.put("path1", "def");
        vars.put("path2", "ghi");
        vars.put("mp2Name", "jkl");
        vars.put("mp2Value", "mno");
        vars.put("path3", "pqr");
        vars.put("mp3Name", "stu");
        vars.put("mp3Value", "vwx");
        vars.put("extension", "yz");
        vars.put("qp1Name", "ABC");
        vars.put("qp1Value", "DEF");
        vars.put("qp2Name", "GHI");
        vars.put("qp2Value", "JKL");
        vars.put("fragment", "MNO");
        return uriBuilder.buildFromMap(vars);
    }

    private URI buildFromTemplVarsWithStrings(ExtendedUriBuilder uriBuilder) {
        return uriBuilder.build(new Object[]{"abc", "username:password", "www.secure.org", "8080", "def", "ghi", "jkl", "mno", "pqr", "yz", "stu", "vwx", "ABC", "DEF", "GHI", "JKL", "MNO"});
    }

    private void changeWithTemplVars(ExtendedUriBuilder uriBuilder) throws IllegalArgumentException {
        uriBuilder.scheme("{scheme}");
        uriBuilder.userInfo("{userInfo}");
        uriBuilder.host("{host}");
        uriBuilder.port("{port}");
        uriBuilder.replacePath("{path1}");
        uriBuilder.path("{path2}");
        uriBuilder.replaceMatrix("{mp2Name}={mp2Value}");
        uriBuilder.path("{path3}");
        uriBuilder.matrixParam("{mp3Name}", new Object[]{"{mp3Value}"});
        uriBuilder.replaceQuery("{qp1Name}={qp1Value}");
        uriBuilder.queryParam("{qp2Name}", new Object[]{"{qp2Value}"});
        uriBuilder.fragment("{fragment}");
    }

    protected void setUp() throws Exception {
        super.setUp();
        Application.setCurrent((Application)new Application());
        this.uriBuilder = ExtendedUriBuilder.newInstance();
        this.uriBuilder.host("localhost");
        this.uriBuilder.segment(new String[]{"path1", "path2"});
        this.uriBuilder.scheme("http");
        this.uriBuilderWithVars = ExtendedUriBuilder.newInstance();
        this.uriBuilderWithVars.host("localhost");
        this.uriBuilderWithVars.scheme("http");
        this.uriBuilderWithVars.segment(new String[]{"abc", "{var1}", "def", "{var2}"});
        this.uriBuilderWithVars.extension("{extension}");
    }

    public void testBuildFromArray() throws Exception {
        try {
            this.uriBuilderWithVars.build(new Object[]{"123"});
            ExtendedJaxRsUriBuilderTest.fail((String)"must fail, because there are not enough arguments");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        URI uri = this.uriBuilderWithVars.build(new Object[]{"123", "456", ""});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/abc/123/def/456.", uri);
        ExtendedUriBuilder uriBuilder2 = this.uriBuilderWithVars.clone();
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/abc/123/def/456.html", uriBuilder2.build(new Object[]{"123", "456", "html"}));
        ExtendedJaxRsUriBuilderTest.assertEquals((String)this.uriBuilderWithVars.toString(), (String)uriBuilder2.toString());
        uriBuilder2.path("{var3}");
        uri = this.uriBuilderWithVars.build(new Object[]{"123", "456", "pdf"});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/abc/123/def/456.pdf", uri);
        try {
            uriBuilder2.build(new Object[]{"123", "456"});
            ExtendedJaxRsUriBuilderTest.fail((String)"must fail, because there are not enough arguments");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        URI uri2 = uriBuilder2.build(new Object[]{"123", "456", "789", ""});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/abc/123/def/456/789.", uri2);
    }

    public void testBuildFromMap() throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        try {
            this.uriBuilderWithVars.buildFromMap(vars);
            ExtendedJaxRsUriBuilderTest.fail((String)"must fail, because missing UriTemplate variables");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        vars.put("var1", "123");
        try {
            this.uriBuilderWithVars.buildFromMap(vars);
            ExtendedJaxRsUriBuilderTest.fail((String)"must fail, because missing UriTemplate variable");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        vars.put("var2", "456");
        vars.put("extension", "odt");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/abc/123/def/456.odt", this.uriBuilderWithVars.buildFromMap(vars));
        vars.put("var3", "789");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/abc/123/def/456.odt", this.uriBuilderWithVars.buildFromMap(vars));
        vars.put("var2", " ");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/abc/123/def/%20.odt", this.uriBuilderWithVars.buildFromMap(vars));
    }

    public void testBuildWithArgs() throws Exception {
        ExtendedJaxRsUriBuilderTest.assertEquals((Object)URI_NO_EXT, (Object)this.uriBuilder.build(new Object[]{"a", "b"}));
        ExtendedJaxRsUriBuilderTest.assertEquals((Object)URI_NO_EXT, (Object)this.uriBuilder.build(new Object[]{" ", "b"}));
        URI uri = this.uriBuilderWithVars.build(new Object[]{"a", "b", "odt"});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/abc/a/def/b.odt", uri);
        uri = this.uriBuilderWithVars.build(new Object[]{"%20", "b", "xml"});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/abc/%2520/def/b.xml", uri);
        uri = this.uriBuilderWithVars.build(new Object[]{" ", "b", ""});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/abc/%20/def/b.", uri);
    }

    public void testBuildWithoutArgs() throws Exception {
        ExtendedJaxRsUriBuilderTest.assertEquals((Object)URI_NO_EXT, (Object)this.uriBuilder.build(new Object[0]));
        try {
            this.uriBuilderWithVars.build(new Object[0]);
            ExtendedJaxRsUriBuilderTest.fail((String)"must fail, because vars are required");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testClone() {
        ExtendedJaxRsUriBuilderTest.assertEquals((Object)this.uriBuilder.build(new Object[0]), (Object)this.uriBuilder.clone().build(new Object[0]));
    }

    public void testEncode() throws Exception {
        ExtendedUriBuilder uriBuilder = ExtendedUriBuilder.newInstance();
        uriBuilder.host("www.xyz.de");
        uriBuilder.scheme("http");
        uriBuilder.segment(new String[]{"path1", "path2"});
        uriBuilder.path("hh ho");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://www.xyz.de/path1/path2/hh%20ho", uriBuilder, true);
    }

    public void testFragmentEnc() throws Exception {
        this.uriBuilder.fragment(String.valueOf('\t'));
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(URI_NO_EXT + "#%09", this.uriBuilder, true);
        this.uriBuilder.fragment("anker");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(URI_NO_EXT + "#anker", this.uriBuilder, true);
    }

    public void testHostEnc() throws Exception {
        this.uriBuilder.host("test.domain.org");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://test.domain.org/path1/path2", this.uriBuilder, true);
        try {
            this.uriBuilder.host("test.domain .org a");
            ExtendedJaxRsUriBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://test.domain.org/path1/path2", this.uriBuilder, true);
    }

    public void testMatrixParam() throws Exception {
        this.uriBuilder.matrixParam("mp1", new Object[]{"mv1"});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(URI_NO_EXT + ";mp1=mv1", this.uriBuilder, true);
        this.uriBuilder.matrixParam("mp1", new Object[]{"mv2"});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(URI_NO_EXT + ";mp1=mv1;mp1=mv2", this.uriBuilder, true);
        this.uriBuilder.matrixParam("mp3", new Object[]{"mv3"});
        try {
            ExtendedJaxRsUriBuilderTest.assertEqualsURI(URI_NO_EXT + ";mp1=mv1;mp1=mv2;mp3=mv3", this.uriBuilder, true);
        }
        catch (AssertionFailedError afe) {
            ExtendedJaxRsUriBuilderTest.assertEqualsURI(URI_NO_EXT + ";mp3=mv3;mp1=mv1;mp1=mv2", this.uriBuilder, true);
        }
        this.uriBuilder.replaceMatrix("mp4=mv4");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(URI_NO_EXT + ";mp4=mv4", this.uriBuilder, true);
        this.uriBuilder.replaceMatrix("");
        ExtendedJaxRsUriBuilderTest.assertEquals((Object)new URI(URI_NO_EXT + ";"), (Object)this.uriBuilder.build(new Object[0]));
        this.uriBuilder.replaceMatrix(null);
        ExtendedJaxRsUriBuilderTest.assertEquals((Object)URI_NO_EXT, (Object)this.uriBuilder.build(new Object[0]));
        this.uriBuilder.matrixParam("jkj$sdf", new Object[]{"ij a%20"});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(URI_NO_EXT + ";jkj%24sdf=ij%20a%2520", this.uriBuilder, true);
    }

    public void testPathClass() throws Exception {
        this.uriBuilder.replacePath(null);
        this.uriBuilder.path(SimpleTrain.class);
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/train", this.uriBuilder, true);
    }

    public void testPathClassString() throws Exception {
        this.uriBuilder.replacePath(null);
        this.uriBuilder.path(CarListResource.class, "getOffers");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/cars/offers", this.uriBuilder, true);
    }

    public void testPathClassStringEnc() throws Exception {
        this.uriBuilder.replacePath(null);
        this.uriBuilder.path(CarListResource.class, "getOffers");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/cars/offers", this.uriBuilder, true);
    }

    public void testPathMethodArray() throws Exception {
        this.uriBuilder.replacePath(null);
        Method findCar = CarListResource.class.getMethod("findCar", Integer.TYPE);
        Method engine = CarResource.class.getMethod("findEngine", new Class[0]);
        this.uriBuilder.path(CarListResource.class);
        this.uriBuilder.path(findCar).path(engine);
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/cars/5/engine", this.uriBuilder.build(new Object[]{"5"}));
    }

    public void testPathStringArrayEnc() throws Exception {
        this.uriBuilder.segment(new String[]{"jjj", "kkk", "ll"});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(URI_NO_EXT + "/jjj/kkk/ll", this.uriBuilder, true);
        this.uriBuilder.path("mno");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(URI_NO_EXT + "/jjj/kkk/ll/mno", this.uriBuilder, true);
        this.uriBuilder.path(" ");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(URI_NO_EXT + "/jjj/kkk/ll/mno/%20", this.uriBuilder, true);
    }

    public void testPort() throws Exception {
        this.uriBuilder.port(4711);
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost:4711/path1/path2", this.uriBuilder, true);
        this.uriBuilder.port(-1);
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/path1/path2", this.uriBuilder, true);
    }

    public void testQueryEnc() throws Exception {
        this.uriBuilder.queryParam("qn", new Object[]{"qv"});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(URI_NO_EXT + "?qn=qv", this.uriBuilder, true);
        this.uriBuilder.queryParam("qn", new Object[]{"qv2"});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(URI_NO_EXT + "?qn=qv&qn=qv2", this.uriBuilder, true);
        this.uriBuilder.queryParam("qn3", new Object[]{"qv3"});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(URI_NO_EXT + "?qn=qv&qn=qv2&qn3=qv3", this.uriBuilder, true);
        this.uriBuilder.replaceQuery("qnNew=qvNew");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(URI_NO_EXT + "?qnNew=qvNew", this.uriBuilder, true);
        this.uriBuilder.replaceQuery(null);
        this.uriBuilder.queryParam("na$me", new Object[]{"George U."});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(URI_NO_EXT + "?na%24me=George%20U.", this.uriBuilder, true);
    }

    public void testreplaceMatrix() throws Exception {
        this.uriBuilder.matrixParam("a", new Object[]{"b"});
        this.uriBuilder.matrixParam("c", new Object[]{"d"});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/path1/path2;a=b;c=d", this.uriBuilder);
        this.uriBuilder.replaceMatrix("ksd hflk");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/path1/path2;ksd%20hflk", this.uriBuilder);
        this.uriBuilder.replaceMatrix("e=f");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/path1/path2;e=f", this.uriBuilder);
    }

    public void testReplacePath() throws Exception {
        this.uriBuilder.replacePath("newPath");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/newPath", this.uriBuilder);
        this.uriBuilder.replacePath("");
        ExtendedJaxRsUriBuilderTest.assertEqualUriBuilder("http", null, "localhost", null, "", null, null, this.uriBuilder, true);
        ExtendedJaxRsUriBuilderTest.assertEqualsUriSlashAllowed("http://localhost", this.uriBuilder);
        this.uriBuilder.replacePath("gh").path("r t");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/gh/r%20t", this.uriBuilder);
        this.uriBuilder.replacePath("gh").path("r;t");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/gh/r;t", this.uriBuilder);
        this.uriBuilder.replacePath("gh").path("r;t=6");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/gh/r;t=6", this.uriBuilder);
        this.uriBuilder.replacePath("gh").path("r;t=");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/gh/r;t=", this.uriBuilder);
        this.uriBuilder.replacePath("gh").path("r;t=6;g");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/gh/r;t=6;g", this.uriBuilder);
    }

    public void testReplaceQueryParams() throws Exception {
        this.uriBuilder.queryParam("a", new Object[]{"b"});
        this.uriBuilder.queryParam("c", new Object[]{"d"});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/path1/path2?a=b&c=d", this.uriBuilder);
        this.uriBuilder.replaceQuery("ksd hflk");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/path1/path2?ksd+hflk", this.uriBuilder);
        this.uriBuilder.replaceQuery("e=f");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://localhost/path1/path2?e=f", this.uriBuilder);
    }

    public void testScheme() throws Exception {
        this.uriBuilder.scheme("ftp");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("ftp://localhost/path1/path2", this.uriBuilder);
        this.uriBuilder.scheme("f4.-+tp");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("f4.-+tp://localhost/path1/path2", this.uriBuilder);
        try {
            this.uriBuilder.scheme("44");
            ExtendedJaxRsUriBuilderTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("f4.-+tp://localhost/path1/path2", this.uriBuilder);
        try {
            this.uriBuilder.scheme("f\u0000");
            ExtendedJaxRsUriBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("f4.-+tp://localhost/path1/path2", this.uriBuilder);
    }

    public void testSchemeSpecificPart() throws Exception {
        this.uriBuilder.schemeSpecificPart("//shkf");
        this.uriBuilder.replacePath("");
        ExtendedJaxRsUriBuilderTest.assertEqualUriBuilder("http", null, "shkf", null, "", null, null, this.uriBuilder, true);
        this.uriBuilder.schemeSpecificPart("//shkf-host/akfshdf");
        ExtendedJaxRsUriBuilderTest.assertEqualUriBuilder("http", null, "shkf-host", null, "/akfshdf", null, null, this.uriBuilder, true);
        this.uriBuilder.schemeSpecificPart("//user@shkf/akfshdf/akjhf");
        ExtendedJaxRsUriBuilderTest.assertEqualUriBuilder("http", "user", "shkf", null, "/akfshdf/akjhf", null, null, this.uriBuilder, true);
        this.uriBuilder.schemeSpecificPart("//shkf:4711/akjhf?a=b");
        ExtendedJaxRsUriBuilderTest.assertEqualUriBuilder("http", null, "shkf", "4711", "/akjhf", null, "a=b", this.uriBuilder, true);
        this.uriBuilder.schemeSpecificPart("//www.domain.org/akjhf;1=2?a=b");
        ExtendedJaxRsUriBuilderTest.assertEqualUriBuilder("http", null, "www.domain.org", null, "/akjhf;1=2", null, "a=b", this.uriBuilder, true);
        this.uriBuilder.schemeSpecificPart("//www.domain.org/akjhf;1=2;3=4?a=b");
        ExtendedJaxRsUriBuilderTest.assertEqualUriBuilder("http", null, "www.domain.org", null, "/akjhf;1=2;3=4", null, "a=b", this.uriBuilder, true);
        this.uriBuilder.schemeSpecificPart("//www.domain.org/ ");
        ExtendedJaxRsUriBuilderTest.assertEquals((String)"http://www.domain.org/%20", (String)this.uriBuilder.build(new Object[0]).toString());
    }

    public void testStaticFromPath() throws Exception {
        ExtendedUriBuilder uriBuilder = ExtendedUriBuilder.fromPath((String)"path");
        ExtendedJaxRsUriBuilderTest.assertEqualUriBuilder(null, null, null, null, "path", null, null, uriBuilder, true);
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("path", uriBuilder);
        uriBuilder = ExtendedUriBuilder.fromPath((String)"path1/path2/abc.html");
        ExtendedJaxRsUriBuilderTest.assertEqualUriBuilder(null, null, null, null, "path1/path2/abc", ".html", null, uriBuilder, true);
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("path1/path2/abc.html", uriBuilder);
        uriBuilder = ExtendedUriBuilder.fromPath((String)"path1/path2;mp1=mv 1;mp2=mv2/abc.html");
        ExtendedJaxRsUriBuilderTest.assertEqualUriBuilder(null, null, null, null, "path1/path2;mp1=mv%201;mp2=mv2/abc", ".html", null, uriBuilder, false);
        ExtendedJaxRsUriBuilderTest.assertEquals((String)"path1/path2;mp1=mv%201;mp2=mv2/abc.html", (String)uriBuilder.build(new Object[0]).toString());
        String path = "path1/path2;mp1=mv1" + Reference.encode((String)"?") + ";mp2=mv2/abc.html";
        uriBuilder = ExtendedUriBuilder.fromPath((String)path);
        ExtendedJaxRsUriBuilderTest.assertEqualUriBuilder(null, null, null, null, "path1/path2;mp1=mv1%3F;mp2=mv2/abc", ".html", null, uriBuilder, false);
    }

    public void testTemplateParams() throws Exception {
        this.changeWithTemplVars(this.uriBuilderWithVars);
        URI uri = this.buildFromTemplVarsWithMap(this.uriBuilderWithVars);
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(TEMPL_VARS_EXPECTED, uri);
        uri = this.buildFromTemplVarsWithStrings(this.uriBuilderWithVars);
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(TEMPL_VARS_EXPECTED, uri);
    }

    public void testToString() {
        ExtendedJaxRsUriBuilderTest.assertEquals((String)"http://localhost/path1/path2", (String)this.uriBuilder.toString());
    }

    public void testUri() throws Exception {
        URI u = new URI("ftp", "test.org", null, null, "fragment");
        this.uriBuilder.uri(u);
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("ftp://test.org/#fragment", this.uriBuilder);
        u = new URI("ftp", "test.org", "/path", "qu=ery", "fragment");
        this.uriBuilder.uri(u);
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("ftp://test.org/path?qu=ery#fragment", this.uriBuilder);
        String id = "4711";
        URI collectionUri = new URI("http://localhost:8181/SecurityContextTestService");
        URI location = ExtendedUriBuilder.fromUri((URI)collectionUri).path("{id}").build(new Object[]{"4711"});
        ExtendedJaxRsUriBuilderTest.assertEqualsURI(collectionUri + "/4711", location);
    }

    public void testUserInfo() throws Exception {
        this.uriBuilder.userInfo("username");
        ExtendedJaxRsUriBuilderTest.assertEqualsURI("http://username@localhost/path1/path2", this.uriBuilder);
        this.uriBuilder.replacePath((String)null);
        this.uriBuilder.host("abc");
        this.uriBuilder.userInfo("username:pw");
        ExtendedJaxRsUriBuilderTest.assertEqualsUriSlashAllowed("http://username:pw@abc", this.uriBuilder);
        this.uriBuilder.userInfo("rkj;s78:&=+$,");
        ExtendedJaxRsUriBuilderTest.assertEqualsUriSlashAllowed("http://rkj;s78:&=+$,@abc", this.uriBuilder);
        this.uriBuilder.userInfo(" ");
        ExtendedJaxRsUriBuilderTest.assertEqualsUriSlashAllowed("http://%20@abc", this.uriBuilder);
    }

    static {
        try {
            URI_NO_EXT = new URI("http://localhost/path1/path2");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Can not initialize ExtendedJaxRsUriBuilderTest");
        }
    }
}

