/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import org.junit.Assert;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Router;
import org.restlet.test.engine.BaseConnectorsTestCase;

public class RemoteClientAddressTestCase
extends BaseConnectorsTestCase {
    protected void call(String uri) throws Exception {
        Request request = new Request(Method.GET, uri);
        Client c = new Client(Protocol.HTTP);
        Response r = c.handle(request);
        RemoteClientAddressTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)r.getStatus());
        c.stop();
    }

    protected Application createApplication(Component component) {
        Application application = new Application(){

            public Restlet createInboundRoot() {
                Router router = new Router(this.getContext());
                router.attach("/test", RemoteClientAddressResource.class);
                return router;
            }
        };
        return application;
    }

    public static class RemoteClientAddressResource
    extends ServerResource {
        public RemoteClientAddressResource() {
            this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        }

        public Representation get(Variant variant) {
            Assert.assertEquals((Object)"127.0.0.1", (Object)this.getRequest().getClientInfo().getAddress());
            Assert.assertTrue((this.getRequest().getClientInfo().getPort() > 0 ? 1 : 0) != 0);
            return new StringRepresentation((CharSequence)"OK");
        }
    }
}

