/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import java.util.Date;
import java.util.List;
import org.restlet.engine.util.DateUtils;
import org.restlet.test.RestletTestCase;

public class DateTestCase
extends RestletTestCase {
    private String DATE_RFC3339_1 = "1985-04-12T23:20:50.52Z";
    private String DATE_RFC3339_2 = "1996-12-19T16:39:57-08:00";
    private String DATE_RFC3339_3 = "1990-12-31T23:59:60Z";
    private String DATE_RFC3339_4 = "1990-12-31T15:59:60-08:00";
    private String DATE_RFC3339_5 = "1937-01-01T12:00:27.87+00:20";
    private String DATE_ASC_1 = "Fri Apr 12 23:20:50 1985";
    private String DATE_RFC1036_1 = "Friday, 12-Apr-85 23:20:50 GMT";
    private String DATE_RFC1123_1 = "Fri, 12 Apr 1985 23:20:50 GMT";
    private String DATE_RFC822_1 = "Fri, 12 Apr 85 23:20:50 GMT";

    public void testRfc822() throws Exception {
        Date date1 = DateUtils.parse((String)this.DATE_RFC822_1, (List)DateUtils.FORMAT_RFC_822);
        String dateFormat1 = DateUtils.format((Date)date1, (String)((String)DateUtils.FORMAT_RFC_822.get(0)));
        DateTestCase.assertEquals((String)this.DATE_RFC822_1, (String)dateFormat1);
    }

    public void testRfc1123() throws Exception {
        Date date1 = DateUtils.parse((String)this.DATE_RFC1123_1, (List)DateUtils.FORMAT_RFC_1123);
        String dateFormat1 = DateUtils.format((Date)date1, (String)((String)DateUtils.FORMAT_RFC_1123.get(0)));
        DateTestCase.assertEquals((String)this.DATE_RFC1123_1, (String)dateFormat1);
    }

    public void testRfc1036() throws Exception {
        Date date1 = DateUtils.parse((String)this.DATE_RFC1036_1, (List)DateUtils.FORMAT_RFC_1036);
        String dateFormat1 = DateUtils.format((Date)date1, (String)((String)DateUtils.FORMAT_RFC_1036.get(0)));
        DateTestCase.assertEquals((String)this.DATE_RFC1036_1, (String)dateFormat1);
    }

    public void testAsc() throws Exception {
        Date date1 = DateUtils.parse((String)this.DATE_ASC_1, (List)DateUtils.FORMAT_ASC_TIME);
        String dateFormat1 = DateUtils.format((Date)date1, (String)((String)DateUtils.FORMAT_ASC_TIME.get(0)));
        DateTestCase.assertEquals((String)this.DATE_ASC_1, (String)dateFormat1);
    }

    public void testRfc3339() throws Exception {
        Date date1 = DateUtils.parse((String)this.DATE_RFC3339_1, (List)DateUtils.FORMAT_RFC_3339);
        Date date2 = DateUtils.parse((String)this.DATE_RFC3339_2, (List)DateUtils.FORMAT_RFC_3339);
        Date date3 = DateUtils.parse((String)this.DATE_RFC3339_3, (List)DateUtils.FORMAT_RFC_3339);
        Date date4 = DateUtils.parse((String)this.DATE_RFC3339_4, (List)DateUtils.FORMAT_RFC_3339);
        Date date5 = DateUtils.parse((String)this.DATE_RFC3339_5, (List)DateUtils.FORMAT_RFC_3339);
        String dateFormat1 = DateUtils.format((Date)date1, (String)((String)DateUtils.FORMAT_RFC_3339.get(0)));
        String dateFormat2 = DateUtils.format((Date)date2, (String)((String)DateUtils.FORMAT_RFC_3339.get(0)));
        String dateFormat3 = DateUtils.format((Date)date3, (String)((String)DateUtils.FORMAT_RFC_3339.get(0)));
        String dateFormat4 = DateUtils.format((Date)date4, (String)((String)DateUtils.FORMAT_RFC_3339.get(0)));
        String dateFormat5 = DateUtils.format((Date)date5, (String)((String)DateUtils.FORMAT_RFC_3339.get(0)));
        DateTestCase.assertEquals((String)this.DATE_RFC3339_1, (String)dateFormat1);
        DateTestCase.assertEquals((String)"1996-12-20T00:39:57Z", (String)dateFormat2);
        DateTestCase.assertEquals((String)"1991-01-01T00:00:00Z", (String)dateFormat3);
        DateTestCase.assertEquals((String)"1991-01-01T00:00:00Z", (String)dateFormat4);
        DateTestCase.assertEquals((String)"1937-01-01T11:40:27.87Z", (String)dateFormat5);
    }
}

