/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.restlet.data.ClientInfo;
import org.restlet.data.Product;
import org.restlet.engine.http.header.ProductReader;
import org.restlet.engine.http.header.ProductWriter;
import org.restlet.test.RestletTestCase;

public class ProductTokenTestCase
extends RestletTestCase {
    public void testMainProduct() {
        String userAgent1 = "Mozilla/4.0 (compatible; MSIE 6.0; America Online Browser 1.1; rev1.1; Windows NT 5.1;)";
        String userAgent2 = "Mozilla/5.0 (Macintosh; U; PPC Mac OS X; en-US; rv:1.8) Gecko/20051107 Camino/1.0b1";
        String userAgent3 = "Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:0.9.2) Gecko/20020508 Netscape6/6.1";
        String userAgent4 = "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1) Gecko/20061024 Iceweasel/2.0 (Debian-2.0+dfsg-1)";
        String userAgent5 = "Mozilla/5.0 (compatible; Konqueror/3.5; Linux 2.6.15-1.2054_FC5; X11; i686; en_US) KHTML/3.5.4 (like Gecko)";
        String userAgent6 = "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)";
        String userAgent7 = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)";
        String userAgent8 = "Mozilla/5.0 (Macintosh; U; PPC Mac OS X; en) AppleWebKit/521.25 (KHTML, like Gecko) Safari/521.24";
        String userAgent9 = "Opera/9.00 (Macintosh; PPC Mac OS X; U; en)";
        String userAgent10 = "Wget/1.9";
        String userAgent11 = "Noelios-Restlet-Engine/1.9-SNAPSHOT";
        ClientInfo clientInfo = new ClientInfo();
        clientInfo.setAgent("Mozilla/4.0 (compatible; MSIE 6.0; America Online Browser 1.1; rev1.1; Windows NT 5.1;)");
        Product product = clientInfo.getMainAgentProduct();
        ProductTokenTestCase.assertEquals((String)"MSIE", (String)product.getName());
        ProductTokenTestCase.assertEquals((String)"6.0", (String)product.getVersion());
        clientInfo = new ClientInfo();
        clientInfo.setAgent("Mozilla/5.0 (Macintosh; U; PPC Mac OS X; en-US; rv:1.8) Gecko/20051107 Camino/1.0b1");
        product = clientInfo.getMainAgentProduct();
        ProductTokenTestCase.assertEquals((String)"Camino", (String)product.getName());
        ProductTokenTestCase.assertEquals((String)"1.0b1", (String)product.getVersion());
        clientInfo = new ClientInfo();
        clientInfo.setAgent("Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:0.9.2) Gecko/20020508 Netscape6/6.1");
        product = clientInfo.getMainAgentProduct();
        ProductTokenTestCase.assertEquals((String)"Netscape6", (String)product.getName());
        ProductTokenTestCase.assertEquals((String)"6.1", (String)product.getVersion());
        clientInfo = new ClientInfo();
        clientInfo.setAgent("Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1) Gecko/20061024 Iceweasel/2.0 (Debian-2.0+dfsg-1)");
        product = clientInfo.getMainAgentProduct();
        ProductTokenTestCase.assertEquals((String)"Iceweasel", (String)product.getName());
        ProductTokenTestCase.assertEquals((String)"2.0", (String)product.getVersion());
        ProductTokenTestCase.assertEquals((String)"Debian-2.0+dfsg-1", (String)product.getComment());
        clientInfo = new ClientInfo();
        clientInfo.setAgent("Mozilla/5.0 (compatible; Konqueror/3.5; Linux 2.6.15-1.2054_FC5; X11; i686; en_US) KHTML/3.5.4 (like Gecko)");
        product = clientInfo.getMainAgentProduct();
        ProductTokenTestCase.assertEquals((String)"Konqueror", (String)product.getName());
        ProductTokenTestCase.assertEquals((String)"3.5.4", (String)product.getVersion());
        clientInfo = new ClientInfo();
        clientInfo.setAgent("Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)");
        product = clientInfo.getMainAgentProduct();
        ProductTokenTestCase.assertEquals((String)"MSIE", (String)product.getName());
        ProductTokenTestCase.assertEquals((String)"5.5", (String)product.getVersion());
        clientInfo = new ClientInfo();
        clientInfo.setAgent("Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
        product = clientInfo.getMainAgentProduct();
        ProductTokenTestCase.assertEquals((String)"MSIE", (String)product.getName());
        ProductTokenTestCase.assertEquals((String)"6.0", (String)product.getVersion());
        clientInfo = new ClientInfo();
        clientInfo.setAgent("Mozilla/5.0 (Macintosh; U; PPC Mac OS X; en) AppleWebKit/521.25 (KHTML, like Gecko) Safari/521.24");
        product = clientInfo.getMainAgentProduct();
        ProductTokenTestCase.assertEquals((String)"Safari", (String)product.getName());
        ProductTokenTestCase.assertEquals((String)"521.24", (String)product.getVersion());
        clientInfo = new ClientInfo();
        clientInfo.setAgent("Opera/9.00 (Macintosh; PPC Mac OS X; U; en)");
        product = clientInfo.getMainAgentProduct();
        ProductTokenTestCase.assertEquals((String)"Opera", (String)product.getName());
        ProductTokenTestCase.assertEquals((String)"9.00", (String)product.getVersion());
        clientInfo = new ClientInfo();
        clientInfo.setAgent("Wget/1.9");
        product = clientInfo.getMainAgentProduct();
        ProductTokenTestCase.assertEquals((String)"Wget", (String)product.getName());
        ProductTokenTestCase.assertEquals((String)"1.9", (String)product.getVersion());
        clientInfo = new ClientInfo();
        clientInfo.setAgent("Noelios-Restlet-Engine/1.9-SNAPSHOT");
        product = clientInfo.getMainAgentProduct();
        ProductTokenTestCase.assertEquals((String)"Noelios-Restlet-Engine", (String)product.getName());
        ProductTokenTestCase.assertEquals((String)"1.9-SNAPSHOT", (String)product.getVersion());
        clientInfo = new ClientInfo();
        clientInfo.setAgent("Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
        Map map = clientInfo.getAgentAttributes();
        for (String key : map.keySet()) {
            System.out.println("[" + key + "," + (String)map.get(key) + "]");
        }
    }

    public void testProductTokens() throws Exception {
        String userAgent1 = "Mozilla/4.0 (compatible; MSIE 6.0; America Online Browser 1.1; rev1.1; Windows NT 5.1;)";
        String userAgent2 = "Advanced Browser (http://www.avantbrowser.com)";
        String userAgent3 = "Mozilla/5.0";
        String userAgent4 = "Mozilla";
        String userAgent5 = "Mozilla/5.0 (Macintosh; U; PPC Mac OS X; en-US; rv:1.8) Gecko/20051107 Camino/1.0b1";
        String userAgent6 = "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1) Gecko/20061024 Iceweasel/2.0 (Debian-2.0+dfsg-1)";
        List list = ProductReader.read((String)"Mozilla/4.0 (compatible; MSIE 6.0; America Online Browser 1.1; rev1.1; Windows NT 5.1;)");
        ProductTokenTestCase.assertEquals((int)1, (int)list.size());
        ProductTokenTestCase.assertEquals((String)"Mozilla", (String)((Product)list.get(0)).getName());
        ProductTokenTestCase.assertEquals((String)"4.0", (String)((Product)list.get(0)).getVersion());
        ProductTokenTestCase.assertEquals((String)"compatible; MSIE 6.0; America Online Browser 1.1; rev1.1; Windows NT 5.1;", (String)((Product)list.get(0)).getComment());
        list = ProductReader.read((String)"Advanced Browser (http://www.avantbrowser.com)");
        ProductTokenTestCase.assertEquals((int)1, (int)list.size());
        ProductTokenTestCase.assertEquals((String)((Product)list.get(0)).getName(), (String)"Advanced Browser");
        ProductTokenTestCase.assertNull((Object)((Product)list.get(0)).getVersion());
        ProductTokenTestCase.assertEquals((String)((Product)list.get(0)).getComment(), (String)"http://www.avantbrowser.com");
        list = ProductReader.read((String)"Mozilla/5.0");
        ProductTokenTestCase.assertEquals((int)1, (int)list.size());
        ProductTokenTestCase.assertEquals((String)"Mozilla", (String)((Product)list.get(0)).getName());
        ProductTokenTestCase.assertEquals((String)"5.0", (String)((Product)list.get(0)).getVersion());
        ProductTokenTestCase.assertNull((Object)((Product)list.get(0)).getComment());
        list = ProductReader.read((String)"Mozilla");
        ProductTokenTestCase.assertEquals((int)1, (int)list.size());
        ProductTokenTestCase.assertEquals((String)"Mozilla", (String)((Product)list.get(0)).getName());
        ProductTokenTestCase.assertNull((Object)((Product)list.get(0)).getVersion());
        ProductTokenTestCase.assertNull((Object)((Product)list.get(0)).getComment());
        list = ProductReader.read((String)"Mozilla/5.0 (Macintosh; U; PPC Mac OS X; en-US; rv:1.8) Gecko/20051107 Camino/1.0b1");
        ProductTokenTestCase.assertEquals((int)3, (int)list.size());
        ProductTokenTestCase.assertEquals((String)"Mozilla", (String)((Product)list.get(0)).getName());
        ProductTokenTestCase.assertEquals((String)"5.0", (String)((Product)list.get(0)).getVersion());
        ProductTokenTestCase.assertEquals((String)"Macintosh; U; PPC Mac OS X; en-US; rv:1.8", (String)((Product)list.get(0)).getComment());
        ProductTokenTestCase.assertEquals((String)"Gecko", (String)((Product)list.get(1)).getName());
        ProductTokenTestCase.assertEquals((String)"20051107", (String)((Product)list.get(1)).getVersion());
        ProductTokenTestCase.assertNull((Object)((Product)list.get(1)).getComment());
        ProductTokenTestCase.assertEquals((String)"Camino", (String)((Product)list.get(2)).getName());
        ProductTokenTestCase.assertEquals((String)"1.0b1", (String)((Product)list.get(2)).getVersion());
        ProductTokenTestCase.assertNull((Object)((Product)list.get(2)).getComment());
        list = ProductReader.read((String)"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1) Gecko/20061024 Iceweasel/2.0 (Debian-2.0+dfsg-1)");
        ProductTokenTestCase.assertEquals((int)3, (int)list.size());
        ProductTokenTestCase.assertEquals((String)"Mozilla", (String)((Product)list.get(0)).getName());
        ProductTokenTestCase.assertEquals((String)"5.0", (String)((Product)list.get(0)).getVersion());
        ProductTokenTestCase.assertEquals((String)"X11; U; Linux i686; en-US; rv:1.8.1", (String)((Product)list.get(0)).getComment());
        ProductTokenTestCase.assertEquals((String)"Gecko", (String)((Product)list.get(1)).getName());
        ProductTokenTestCase.assertEquals((String)"20061024", (String)((Product)list.get(1)).getVersion());
        ProductTokenTestCase.assertNull((Object)((Product)list.get(1)).getComment());
        ProductTokenTestCase.assertEquals((String)"Iceweasel", (String)((Product)list.get(2)).getName());
        ProductTokenTestCase.assertEquals((String)"2.0", (String)((Product)list.get(2)).getVersion());
        ProductTokenTestCase.assertEquals((String)"Debian-2.0+dfsg-1", (String)((Product)list.get(2)).getComment());
        ArrayList<Product> products = new ArrayList<Product>();
        products.add(new Product("Product", "1.2", null));
        products.add(new Product("Nre", "1.1m4", "This is a comment"));
        list = ProductReader.read((String)ProductWriter.write(products));
        ProductTokenTestCase.assertEquals((int)2, (int)list.size());
        ProductTokenTestCase.assertEquals((String)"Product", (String)((Product)list.get(0)).getName());
        ProductTokenTestCase.assertEquals((String)"1.2", (String)((Product)list.get(0)).getVersion());
        ProductTokenTestCase.assertNull((Object)((Product)list.get(0)).getComment());
        ProductTokenTestCase.assertEquals((String)"Nre", (String)((Product)list.get(1)).getName());
        ProductTokenTestCase.assertEquals((String)"1.1m4", (String)((Product)list.get(1)).getVersion());
        ProductTokenTestCase.assertEquals((String)"This is a comment", (String)((Product)list.get(1)).getComment());
    }
}

