/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test;

import java.util.Arrays;
import java.util.List;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ClientInfo;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.http.Call;
import org.restlet.test.RestletTestCase;

public class CallTestCase
extends RestletTestCase {
    protected Call getCall() {
        return new Call(){

            protected boolean isClientKeepAlive() {
                return false;
            }

            protected boolean isServerKeepAlive() {
                return false;
            }
        };
    }

    protected Reference getReference(String uri) {
        return new Reference(uri);
    }

    protected Request getRequest() {
        return new Request();
    }

    protected Response getResponse(Request request) {
        return new Response(request);
    }

    public void testBaseRef() throws Exception {
        Request request = this.getRequest();
        String resourceRefURI = "http://www.restlet.org/path/to/resource";
        Reference resourceRef = this.getReference("http://www.restlet.org/path/to/resource");
        request.setResourceRef("http://www.restlet.org/path/to/resource");
        CallTestCase.assertEquals((Object)resourceRef, (Object)request.getResourceRef());
        String uri = "http://www.restlet.org/path";
        Reference reference = this.getReference(uri);
        request.getResourceRef().setBaseRef(uri);
        CallTestCase.assertEquals((String)uri, (String)request.getResourceRef().getBaseRef().toString());
        CallTestCase.assertEquals((Object)reference, (Object)request.getResourceRef().getBaseRef());
        uri = "http://www.restlet.org/path/to";
        reference = this.getReference(uri);
        request.getResourceRef().setBaseRef(uri);
        CallTestCase.assertEquals((String)uri, (String)request.getResourceRef().getBaseRef().toString());
        CallTestCase.assertEquals((Object)reference, (Object)request.getResourceRef().getBaseRef());
    }

    public void testClientAddress() throws Exception {
        ClientInfo client = this.getRequest().getClientInfo();
        String address = "127.0.0.1";
        client.setAddress(address);
        CallTestCase.assertEquals((String)address, (String)client.getAddress());
        CallTestCase.assertEquals((int)0, (int)client.getForwardedAddresses().size());
    }

    public void testClientForwardedAddresses() throws Exception {
        ClientInfo client = this.getRequest().getClientInfo();
        String firstAddress = "127.0.0.1";
        String secondAddress = "192.168.99.10";
        List<String> addresses = Arrays.asList(firstAddress, "192.168.99.10");
        client.getForwardedAddresses().addAll(addresses);
        CallTestCase.assertEquals(addresses, (Object)client.getForwardedAddresses());
        client.getForwardedAddresses().clear();
        client.getForwardedAddresses().addAll(addresses);
        CallTestCase.assertEquals(addresses, (Object)client.getForwardedAddresses());
    }

    public void testClientAgent() throws Exception {
        ClientInfo client = this.getRequest().getClientInfo();
        String name = "Restlet";
        client.setAgent(name);
        CallTestCase.assertEquals((String)name, (String)client.getAgent());
        name = "Restlet Client";
        client.setAgent(name);
        CallTestCase.assertEquals((String)name, (String)client.getAgent());
    }

    public void testMethod() throws Exception {
        Request request = this.getRequest();
        request.setMethod(Method.GET);
        CallTestCase.assertEquals((Object)Method.GET, (Object)request.getMethod());
        request.setMethod(Method.POST);
        CallTestCase.assertEquals((Object)Method.POST, (Object)request.getMethod());
    }

    public void testRedirectionRef() throws Exception {
        Request request = this.getRequest();
        Response response = this.getResponse(request);
        String uri = "http://www.restlet.org/";
        Reference reference = this.getReference(uri);
        response.setLocationRef(uri);
        CallTestCase.assertEquals((Object)reference, (Object)response.getLocationRef());
        uri = "http://www.restlet.org/something";
        reference = this.getReference(uri);
        response.setLocationRef(reference);
        CallTestCase.assertEquals((Object)reference, (Object)response.getLocationRef());
    }

    public void testReferrerRef() throws Exception {
        Request request = this.getRequest();
        String uri = "http://www.restlet.org/";
        Reference reference = this.getReference(uri);
        request.setReferrerRef(uri);
        CallTestCase.assertEquals((Object)reference, (Object)request.getReferrerRef());
        uri = "http://www.restlet.org/something";
        reference = this.getReference(uri);
        request.setReferrerRef(reference);
        CallTestCase.assertEquals((Object)reference, (Object)request.getReferrerRef());
    }

    public void testResourceRef() throws Exception {
        Request request = this.getRequest();
        String uri = "http://www.restlet.org/";
        Reference reference = this.getReference(uri);
        request.setResourceRef(uri);
        CallTestCase.assertEquals((Object)reference, (Object)request.getResourceRef());
        uri = "http://www.restlet.org/something";
        reference = this.getReference(uri);
        request.setResourceRef(reference);
        CallTestCase.assertEquals((Object)reference, (Object)request.getResourceRef());
    }

    public void testServerAddress() throws Exception {
        Request request = this.getRequest();
        Response response = this.getResponse(request);
        String address = "127.0.0.1";
        response.getServerInfo().setAddress(address);
        CallTestCase.assertEquals((String)address, (String)response.getServerInfo().getAddress());
        address = "192.168.99.10";
        response.getServerInfo().setAddress(address);
        CallTestCase.assertEquals((String)address, (String)response.getServerInfo().getAddress());
    }

    public void testServerAgent() throws Exception {
        Request request = this.getRequest();
        Response response = this.getResponse(request);
        String name = "Restlet";
        response.getServerInfo().setAgent(name);
        CallTestCase.assertEquals((String)name, (String)response.getServerInfo().getAgent());
        name = "Restlet Server";
        response.getServerInfo().setAgent(name);
        CallTestCase.assertEquals((String)name, (String)response.getServerInfo().getAgent());
    }

    public void testStatus() throws Exception {
        Request request = this.getRequest();
        Response response = this.getResponse(request);
        response.setStatus(Status.SUCCESS_OK);
        CallTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        CallTestCase.assertEquals((Object)Status.CLIENT_ERROR_BAD_REQUEST, (Object)response.getStatus());
    }
}

