/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.netty.internal;

import java.lang.reflect.Constructor;
import org.jboss.netty.buffer.ChannelBufferFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NettyParams {
    keepAlive(Boolean.class, true),
    bufferFactoryClass(ChannelBufferFactory.class, true),
    connectTimeoutMillis(Integer.class, true),
    reuseAddress(Boolean.class, true),
    receiveBufferSize(Integer.class, true),
    sendBufferSize(Integer.class, true),
    trafficClass(Integer.class, true),
    sslContextFactory(String.class, false),
    keystorePath(String.class, false),
    keystorePassword(String.class, false),
    keyPassword(String.class, false),
    keystoreType(String.class, false),
    truststorePath(String.class, false),
    truststorePassword(String.class, false),
    certAlgorithm(String.class, false),
    sslProtocol(String.class, false),
    needClientAuthentication(String.class, false),
    wantClientAuthentication(String.class, false);

    private final Class<?> paramType;
    private final Boolean isChannelOption;

    private NettyParams(Class<?> type, Boolean isChannelParam) {
        this.paramType = type;
        this.isChannelOption = isChannelParam;
    }

    public Object getValue(String value) {
        Object ret = null;
        try {
            Constructor<?> constructor = this.paramType.getConstructor(String.class);
            ret = constructor.newInstance(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret == null) {
            ret = this.instantiateClass(value);
        }
        return ret;
    }

    private Object instantiateClass(String value) {
        Object ret = null;
        Class<?> factory = null;
        try {
            factory = ((Object)((Object)this)).getClass().getClassLoader().loadClass(value);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (factory != null) {
            try {
                Constructor<?> constructor = factory.getConstructor(new Class[0]);
                Object ref = constructor.newInstance(new Object[0]);
                if (ref instanceof ChannelBufferFactory) {
                    ret = ref;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ret;
    }

    public Boolean isChannelOption() {
        return this.isChannelOption;
    }
}

