/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.netty.internal;

import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedStream;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Parameter;
import org.restlet.engine.ConnectorHelper;
import org.restlet.ext.netty.HttpsServerHelper;
import org.restlet.ext.netty.NettyServerHelper;
import org.restlet.ext.netty.internal.NettyServerCall;
import org.restlet.representation.Representation;
import org.restlet.service.ConnectorService;

@ChannelHandler.Sharable
public class HttpRequestHandler
extends SimpleChannelUpstreamHandler {
    static final byte CR = 13;
    static final byte LF = 10;
    private volatile NettyServerHelper helper;
    private volatile boolean readingChunks;
    private volatile HttpRequest request;
    private volatile ChannelBuffer content;
    private volatile InetSocketAddress clientAddress;

    public HttpRequestHandler(NettyServerHelper serverHelper) {
        this.helper = serverHelper;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel ch = e.getChannel();
        Throwable cause = e.getCause();
        if (cause instanceof TooLongFrameException) {
            this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        cause.printStackTrace();
        if (ch.isConnected()) {
            this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        if (this.clientAddress == null) {
            this.clientAddress = (InetSocketAddress)messageEvent.getRemoteAddress();
        }
        boolean lastChunk = false;
        if (!this.readingChunks) {
            this.request = (HttpRequest)messageEvent.getMessage();
            if (this.request.isChunked()) {
                this.readingChunks = true;
            } else {
                this.content = this.request.getContent();
            }
        } else {
            HttpChunk chunk = (HttpChunk)messageEvent.getMessage();
            if (chunk.isLast()) {
                this.readingChunks = false;
                lastChunk = true;
            } else {
                this.content.writeBytes(chunk.getContent());
            }
        }
        if (this.content == null) {
            this.content = ChannelBuffers.dynamicBuffer();
        }
        HttpResponse nettyResponse = null;
        NettyServerCall httpCall = null;
        if (!this.request.isChunked() || lastChunk) {
            SslHandler sslHandler = (SslHandler)ctx.getPipeline().get(SslHandler.class);
            SSLEngine sslEngine = sslHandler == null ? null : sslHandler.getEngine();
            httpCall = new NettyServerCall((Server)this.helper.getHelped(), messageEvent, this.content, this.request, this.clientAddress, this.helper instanceof HttpsServerHelper, sslEngine);
            this.helper.handle(httpCall);
            nettyResponse = httpCall.getResponse();
            Response restletResponse = httpCall.getRestletResponse();
            if (restletResponse != null) {
                Representation responseEntity = restletResponse.getEntity();
                ConnectorService connectorService = ConnectorHelper.getConnectorService();
                if (connectorService != null) {
                    connectorService.beforeSend(responseEntity);
                }
                try {
                    if (nettyResponse != null) {
                        nettyResponse.clearHeaders();
                    } else {
                        HttpResponseStatus status = new HttpResponseStatus(restletResponse.getStatus().getCode(), restletResponse.getStatus().getName());
                        nettyResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
                    }
                    for (Parameter header : httpCall.getResponseHeaders()) {
                        nettyResponse.addHeader(header.getName(), (Object)header.getValue());
                    }
                    if (httpCall.shouldResponseBeChunked(restletResponse)) {
                        nettyResponse.addHeader("Transfer-Encoding", (Object)"chunked");
                    }
                    Channel ch = messageEvent.getChannel();
                    ChannelFuture future = null;
                    if (responseEntity != null) {
                        if (nettyResponse.isChunked()) {
                            nettyResponse.setContent(null);
                            future = ch.write((Object)nettyResponse);
                            ch.write((Object)new ChunkedStream(restletResponse.getEntity().getStream()));
                        } else {
                            ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
                            buf.writeBytes(responseEntity.getStream(), (int)responseEntity.getAvailableSize());
                            nettyResponse.setContent(buf);
                            future = ch.write((Object)nettyResponse);
                        }
                    }
                    if (this.shouldCloseConnection()) {
                        future.addListener(ChannelFutureListener.CLOSE);
                    }
                }
                finally {
                    if (responseEntity != null) {
                        responseEntity.release();
                    }
                    if (connectorService != null) {
                        connectorService.afterSend(responseEntity);
                    }
                }
            }
        }
    }

    private boolean shouldCloseConnection() {
        boolean close = "close".equalsIgnoreCase(this.request.getHeader("Connection")) || this.request.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_0) && !"keep-alive".equalsIgnoreCase(this.request.getHeader("Connection"));
        return close;
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)Charset.forName("UTF-8")));
        ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
    }

    public static byte[] longToHex(long l) {
        long v = l & 0xFFFFFFFFFFFFFFFFL;
        byte[] result = new byte[16];
        Arrays.fill(result, 0, result.length, (byte)0);
        for (int i = 0; i < result.length; i += 2) {
            byte b = (byte)((v & 0xFF00000000000000L) >> 56);
            byte b2 = (byte)(b & 0xF);
            byte b1 = (byte)(b >> 4 & 0xF);
            if (b1 > 9) {
                b1 = (byte)(b1 + 39);
            }
            b1 = (byte)(b1 + 48);
            if (b2 > 9) {
                b2 = (byte)(b2 + 39);
            }
            b2 = (byte)(b2 + 48);
            result[i] = (byte)(b1 & 0xFF);
            result[i + 1] = (byte)(b2 & 0xFF);
            v <<= 8;
        }
        return result;
    }
}

