/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.jaxrs.employees;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.restlet.example.ext.jaxrs.employees.Employee;
import org.restlet.example.ext.jaxrs.employees.EmployeeMgr;

public class EmployeeResource {
    private final EmployeeMgr employeeMgr = EmployeeMgr.get();
    private final int staffNo;

    private static URI createEmployeesUri(UriInfo uriInfo) {
        UriBuilder employeesUri = uriInfo.getBaseUriBuilder();
        employeesUri.path((String)uriInfo.getMatchedURIs().get(0));
        URI build = employeesUri.build(new Object[0]);
        return build;
    }

    EmployeeResource(int persNr) {
        this.staffNo = persNr;
    }

    @DELETE
    public Object delete(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo) {
        this.employeeMgr.remove(this.staffNo);
        if (httpHeaders.getAcceptableMediaTypes().contains(MediaType.TEXT_HTML_TYPE)) {
            return Response.seeOther((URI)EmployeeResource.createEmployeesUri(uriInfo));
        }
        return null;
    }

    @GET
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    public Employee get(@Context UriInfo uriInfo) {
        Employee employee = this.employeeMgr.getFull(this.staffNo);
        UriBuilder departmentUB = uriInfo.getBaseUriBuilder();
        departmentUB.segment(new String[]{"departments", "{depId}"});
        String department = employee.getDepartment();
        employee.setDepartmentUri(departmentUB.build(new Object[]{department}));
        return employee;
    }

    @GET
    @Produces(value={"text/html"})
    public StreamingOutput getHtml(final @Context UriInfo uriInfo) {
        final Employee employee = this.get(uriInfo);
        final URI employeesUri = EmployeeResource.createEmployeesUri(uriInfo);
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException {
                PrintStream ps = new PrintStream(output);
                ps.println("<html><head>");
                ps.println("<title>Employee</title>");
                ps.println("</head></body>");
                ps.println("<h2>Employee</h2>");
                ps.println("<table><tr>");
                ps.println("<td>staff no.</td>");
                ps.println("<td>");
                ps.println(employee.getStaffNo());
                ps.println("</td>");
                ps.println("</tr><tr>");
                ps.println("<td>firstname:</td>");
                ps.println("<td>");
                ps.println(employee.getFirstname());
                ps.println("</td>");
                ps.println("</tr><tr>");
                ps.println("<td>lastname:</td>");
                ps.println("<td>");
                ps.println(employee.getLastname());
                ps.println("</td>");
                ps.println("</tr><tr>");
                ps.println("<td>sex:</td>");
                ps.println("<td>");
                ps.println(employee.getSex());
                ps.println("</td>");
                ps.println("</tr><tr>");
                ps.println("<td>department:</td>");
                ps.println("<td>");
                ps.println(employee.getDepartment());
                ps.println("</td>");
                ps.println("</tr></table>");
                ps.println("<hr>");
                ps.print("<form action=\"");
                ps.print(uriInfo.getAbsolutePath());
                ps.println("?method=DELETE\" method=\"POST\">");
                ps.println("<input type=\"submit\" value=\"Delete employee\" />");
                ps.println("</form>");
                ps.print("<hr><a href=\"");
                ps.print(employeesUri);
                ps.print("\">all employees</a>");
                ps.println("</body></html>");
            }
        };
    }

    @PUT
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    public void update(Employee employee) {
        this.employeeMgr.update(this.staffNo, employee);
    }
}

