/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch08.sec5.website;

import java.io.OutputStream;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.restlet.data.LocalReference;
import org.restlet.data.MediaType;
import org.restlet.example.book.restlet.ch08.sec5.webapi.common.MailRepresentation;
import org.restlet.ext.fileupload.RestletFileUpload;
import org.restlet.ext.freemarker.TemplateRepresentation;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

public class MailServerResource
extends ServerResource {
    protected Representation get() throws ResourceException {
        String accountId = (String)this.getRequestAttributes().get("accountId");
        String mailId = (String)this.getRequestAttributes().get("mailId");
        String mailApiUri = "riap://component/api/accounts/" + accountId + "/mails/" + mailId;
        ClientResource cr = new ClientResource(mailApiUri);
        MailRepresentation mail = (MailRepresentation)cr.get(MailRepresentation.class);
        Representation mailFtl = new ClientResource(LocalReference.createClapReference((Package)((Object)((Object)this)).getClass().getPackage()) + "/Mail.ftl").get();
        return new TemplateRepresentation(mailFtl, (Object)mail, MediaType.TEXT_HTML);
    }

    protected Representation put(Representation input) {
        try {
            RestletFileUpload fileUpload = new RestletFileUpload((FileItemFactory)new DiskFileItemFactory());
            List fileItems = fileUpload.parseRepresentation(input);
            for (FileItem fileItem : fileItems) {
                if (fileItem.isFormField()) {
                    System.out.println(fileItem.getFieldName() + "=" + fileItem.getString());
                    continue;
                }
                InputRepresentation attachment = new InputRepresentation(fileItem.getInputStream());
                attachment.write((OutputStream)System.out);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new StringRepresentation((CharSequence)"Mail updated!");
    }
}

