/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch06.sec4;

import java.io.File;
import java.io.FilenameFilter;
import java.security.PrivilegedAction;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.ext.jaas.JaasUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

public class ListHomeDirResource
extends ServerResource {
    @Get(value="txt")
    public Representation echoPrincipals() throws ResourceException {
        PrivilegedAction<StringBuilder> action = new PrivilegedAction<StringBuilder>(){

            @Override
            public StringBuilder run() {
                File dir = new File(System.getProperty("user.home"));
                String[] filenames = dir.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return !name.startsWith(".");
                    }
                });
                StringBuilder sb = new StringBuilder("Files in the home directory: \n\n");
                for (String filename : filenames) {
                    sb.append(filename);
                    sb.append("\n");
                }
                return sb;
            }
        };
        StringBuilder sb = (StringBuilder)JaasUtils.doAsPriviledged((ClientInfo)this.getRequest().getClientInfo(), (PrivilegedAction)action);
        StringRepresentation rep = new StringRepresentation((CharSequence)sb, MediaType.TEXT_PLAIN, Language.ALL, CharacterSet.UTF_8);
        return rep;
    }
}

