/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.googlecode.jslint4java.Issue;
import com.googlecode.jslint4java.JSLint;
import com.googlecode.jslint4java.JSLintBuilder;
import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.Option;
import com.googlecode.jslint4java.cli.Flags;
import com.googlecode.jslint4java.cli.JSLintFlags;
import com.googlecode.jslint4java.formatter.JSLintResultFormatter;
import com.googlecode.jslint4java.formatter.JSLintXmlFormatter;
import com.googlecode.jslint4java.formatter.JUnitXmlFormatter;
import com.googlecode.jslint4java.formatter.PlainFormatter;
import com.googlecode.jslint4java.formatter.ReportFormatter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Main {
    private static final String PROGNAME = "jslint";
    private Charset encoding = Charset.defaultCharset();
    private boolean errored = false;
    private JSLintResultFormatter formatter;
    private JSLint lint = new JSLintBuilder().fromDefault();

    public static void main(String[] args) throws IOException {
        try {
            System.exit(new Main().run(args));
        }
        catch (DieException e) {
            if (e.getMessage() != null) {
                System.err.println("jslint: " + e.getMessage());
            }
            System.exit(e.getCode());
        }
    }

    private int run(String[] args) throws IOException {
        List<String> files = this.processOptions(args);
        if (this.formatter.header() != null) {
            this.info(this.formatter.header());
        }
        for (String file : files) {
            this.lintFile(file);
        }
        if (this.formatter.footer() != null) {
            this.info(this.formatter.footer());
        }
        return this.isErrored() ? 1 : 0;
    }

    private Main() throws IOException {
    }

    private void die(String message) {
        throw new DieException(message, 1);
    }

    private Option getOption(String optName) {
        try {
            return Option.valueOf(optName.toUpperCase(Locale.getDefault()));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private void info(String message) {
        System.out.println(message);
    }

    private boolean isErrored() {
        return this.errored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lintFile(String file) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding));
            JSLintResult result = this.lint.lint(file, reader);
            this.info(this.formatter.format(result));
            if (!result.getIssues().isEmpty()) {
                this.setErrored(true);
            }
        }
        catch (FileNotFoundException e) {
            this.die(file + ": No such file or directory.");
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private List<String> processOptions(String[] args) {
        JSLintFlags jslintFlags = new JSLintFlags();
        Flags flags = new Flags();
        JCommander jc = new JCommander((Object)new Object[]{flags, jslintFlags}, args);
        jc.setProgramName("jslint4java");
        if (flags.help) {
            this.usage(jc);
        }
        if (flags.encoding != null) {
            this.encoding = flags.encoding;
        }
        if (flags.jslint != null) {
            this.setJSLint(flags.jslint);
        }
        this.setResultFormatter(flags.report);
        for (ParameterDescription pd : jc.getParameters()) {
            Field field = pd.getField();
            if (!field.getDeclaringClass().isAssignableFrom(JSLintFlags.class)) continue;
            try {
                Option o = this.getOption(field.getName());
                Object val = field.get(jslintFlags);
                if (val == null) continue;
                Class<Object> type = field.getType();
                if (type.isAssignableFrom(Boolean.class)) {
                    this.lint.addOption(o);
                    continue;
                }
                if (type.isAssignableFrom(String.class)) {
                    this.lint.addOption(o, (String)val);
                    continue;
                }
                this.die("unknown type \"" + type + "\" (for " + field.getName() + ")");
            }
            catch (IllegalArgumentException e) {
                this.die(e.getMessage());
            }
            catch (IllegalAccessException e) {
                this.die(e.getMessage());
            }
        }
        if (flags.files.isEmpty()) {
            this.usage(jc);
            return null;
        }
        return flags.files;
    }

    private void setErrored(boolean errored) {
        this.errored = errored;
    }

    private void setJSLint(String jslint) {
        try {
            this.lint = new JSLintBuilder().fromFile(new File(jslint));
        }
        catch (IOException e) {
            this.die(e.getMessage());
        }
    }

    private void setResultFormatter(String reportType) {
        if (reportType == null || reportType.equals("")) {
            this.formatter = new DefaultFormatter();
        } else if (reportType.equals("plain")) {
            this.formatter = new PlainFormatter();
        } else if (reportType.equals("xml")) {
            this.formatter = new JSLintXmlFormatter();
        } else if (reportType.equals("junit")) {
            this.formatter = new JUnitXmlFormatter();
        } else if (reportType.equals("report")) {
            this.formatter = new ReportFormatter();
        } else {
            this.die("unknown report type '" + reportType + "'");
        }
    }

    private void usage(JCommander jc) {
        jc.usage();
        this.info("using jslint version " + this.lint.getEdition());
        throw new DieException(null, 0);
    }

    private static class DieException
    extends RuntimeException {
        private final int code;

        public DieException(String message, int code) {
            super(message);
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    private static final class DefaultFormatter
    implements JSLintResultFormatter {
        private DefaultFormatter() {
        }

        public String format(JSLintResult result) {
            StringBuilder sb = new StringBuilder();
            for (Issue issue : result.getIssues()) {
                sb.append(Main.PROGNAME);
                sb.append(':');
                sb.append(issue.toString());
                sb.append('\n');
            }
            return sb.toString();
        }

        public String footer() {
            return null;
        }

        public String header() {
            return null;
        }
    }
}

