/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.ant;

import com.googlecode.jslint4java.ant.JUnitXmlResultFormatter;
import com.googlecode.jslint4java.ant.PlainResultFormatter;
import com.googlecode.jslint4java.ant.ReportResultFormatter;
import com.googlecode.jslint4java.ant.ResultFormatter;
import com.googlecode.jslint4java.ant.XmlResultFormatter;
import java.io.File;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;

public class FormatterElement {
    private Type type;
    private OutputStream defaultOutputStream = System.out;
    private File destFile;

    public ResultFormatter getResultFormatter() {
        if (this.type == null) {
            throw new BuildException("you must specify type");
        }
        ResultFormatter rf = this.type.getResultFormatter();
        rf.setStdout(this.defaultOutputStream);
        if (this.destFile != null) {
            rf.setFile(this.destFile);
        }
        return rf;
    }

    void setDefaultOutputStream(OutputStream defaultOutputStream) {
        this.defaultOutputStream = defaultOutputStream;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void setType(Type type) {
        this.type = type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        plain{

            public ResultFormatter getResultFormatter() {
                return new PlainResultFormatter();
            }
        }
        ,
        xml{

            public ResultFormatter getResultFormatter() {
                return new XmlResultFormatter();
            }
        }
        ,
        junit{

            ResultFormatter getResultFormatter() {
                return new JUnitXmlResultFormatter();
            }
        }
        ,
        report{

            ResultFormatter getResultFormatter() {
                return new ReportResultFormatter();
            }
        };


        abstract ResultFormatter getResultFormatter();
    }
}

