/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java;

import com.googlecode.jslint4java.JSLint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ScriptableObject;

public class JSLintBuilder {
    private static final String JSLINT_FILE = "com/googlecode/jslint4java/fulljslint.js";
    private final ContextFactory contextFactory = new ContextFactory();
    private final Charset utf8 = Charset.forName("UTF-8");

    public JSLint fromClasspathResource(String resource) throws IOException {
        return this.fromClasspathResource(resource, this.utf8);
    }

    public JSLint fromClasspathResource(String resource, Charset encoding) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(resource), encoding));
        return this.fromReader(reader, resource);
    }

    public JSLint fromDefault() {
        try {
            return this.fromClasspathResource(JSLINT_FILE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JSLint fromFile(File f) throws IOException {
        return this.fromFile(f, this.utf8);
    }

    public JSLint fromFile(File f, Charset encoding) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), encoding));
        return this.fromReader(reader, f.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSLint fromReader(Reader reader, String name) throws IOException {
        try {
            Context cx = this.contextFactory.enterContext();
            ScriptableObject scope = cx.initStandardObjects();
            cx.evaluateReader(scope, reader, name, 1, null);
            JSLint jSLint = new JSLint(this.contextFactory, scope);
            return jSLint;
        }
        finally {
            Context.exit();
        }
    }
}

